<?php
declare(strict_types=1);

require_once __DIR__ . '/common.php';

try {
    api_require_https();
    api_require_debug_key();

    $method = strtoupper((string)($_SERVER['REQUEST_METHOD'] ?? 'GET'));
    $contentType = api_content_type();
    $raw = file_get_contents('php://input');
    if ($raw === false) {
        $raw = '';
    }
    if (strncmp($raw, "\xEF\xBB\xBF", 3) === 0) {
        $raw = substr($raw, 3);
    }

    $decoded = json_decode(trim($raw), true);
    $jsonOk = is_array($decoded) && json_last_error() === JSON_ERROR_NONE;
    $jsonError = $jsonOk ? '' : json_last_error_msg();

    $dbOk = false;
    $dbError = '';
    try {
        $pdo = gmap_pdo();
        $pdo->query('SELECT 1');
        $dbOk = true;
    } catch (Throwable $dbEx) {
        $dbError = $dbEx->getMessage();
    }

    api_respond([
        'ok' => true,
        'php_version' => PHP_VERSION,
        'request_method' => $method,
        'content_type' => $contentType,
        'raw_body_length' => strlen($raw),
        'json_decode_ok' => $jsonOk,
        'json_error' => $jsonError,
        'db_connection_ok' => $dbOk,
        'db_error' => $dbOk ? '' : $dbError,
        'time_utc' => gmap_now_utc(),
    ]);
} catch (Throwable $e) {
    api_respond([
        'ok' => false,
        'error' => 'SERVER_ERROR',
        'message' => 'Debug endpoint failed.',
    ], 500);
}
