<?php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

if (admin_is_logged_in()) {
    header('Location: index.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = (string)($_POST['username'] ?? '');
    $password = (string)($_POST['password'] ?? '');
    if (admin_login($username, $password)) {
        header('Location: index.php');
        exit;
    }
    $error = 'Invalid credentials.';
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>GMapScraperPRO Admin Login</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body>
<div class="container narrow">
    <h1>GMapScraperPRO Admin</h1>
    <p class="muted">License control panel</p>
    <?php if ($error !== ''): ?>
        <div class="alert error"><?= admin_h($error) ?></div>
    <?php endif; ?>
    <form method="post" class="card">
        <label>Username</label>
        <input type="text" name="username" required autocomplete="username">
        <label>Password</label>
        <input type="password" name="password" required autocomplete="current-password">
        <button type="submit">Login</button>
    </form>
</div>
</body>
</html>
